set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      NULL,
      37,
      9.005719,
      '3012211',
      39.301206,
      3,
      1.704419,
      NULL,
      '421302',
      5.269101,
      ' 9-11-1996',
      16,
      33.704657,
      0,
      NULL,
      2,
      1.839977,
      NULL,
      1.484028,
      1,
      0,
      0.486176,
      1.578641,
      NULL,
      0.584786,
      1.097160,
      0,
      0,
      NULL,
      0,
      NULL,
      1.427372,
      1,
      NULL,
      0,
      NULL,
      0.690422,
      NULL,
      0,
      4.720975,
      1.645388,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.994331,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.324819,
      0,
      0,
      9,
      0,
      NULL,
      1,
      1.803564,
      NULL,
      NULL,
      1.032249,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.428421,
      0,
      NULL,
      1.133446,
      0.451384,
      1,
      NULL,
      1,
      0,
      1.499513,
      0,
      1.155418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.549739,
      1.831278,
      0,
      NULL,
      NULL,
      4.962810,
      3,
      1,
      NULL,
      1,
      3.998648,
      NULL,
      NULL,
      NULL,
      2,
      1.509176,
      NULL,
      NULL,
      9,
      8.226097,
      NULL,
      4.967769,
      4,
      8,
      9,
      0.552121,
      1,
      0.002438,
      0.566199,
      NULL,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.177572,
      1,
      0.370788,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226378,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      8.600067,
      1.333257,
      2.966112,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480090,
      0.994308,
      0.165960,
      NULL,
      2.746559,
      0,
      NULL,
      1,
      0.518273,
      2.666257,
      2.248770,
      0,
      0.233006,
      1,
      0.020772,
      0.778038,
      0.936665,
      0.592345,
      0.524354,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '32331',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.391362,
      '',
      '',
      '',
      2.250491,
      2.735082,
      0.359366,
      4,
      NULL,
      2,
      3.251193,
      NULL,
      2.369691);
commit;
end;
/


