set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00313024',
      20.148482,
      64.087853,
      NULL,
      122,
      6,
      2.775713,
      1,
      '123112',
      NULL,
      NULL,
      231,
      55.246973,
      1.620287,
      NULL,
      1,
      1,
      0.221957,
      0.112443,
      1,
      0,
      0,
      0.170571,
      1.600532,
      0,
      NULL,
      1,
      0.087017,
      0,
      1.591794,
      7.836622,
      1.240112,
      0.295772,
      0.718547,
      1.013567,
      0.634292,
      1.746240,
      7.558863,
      1,
      3.384185,
      0.954716,
      1.623505,
      NULL,
      NULL,
      NULL,
      0.273168,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      1,
      7,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.031718,
      0.173095,
      NULL,
      1,
      1,
      3.460171,
      0.628167,
      0.358347,
      1.856143,
      0,
      1,
      0.005556,
      2.253633,
      1.322958,
      NULL,
      1.009384,
      1.639198,
      0.065593,
      NULL,
      NULL,
      2.212601,
      0,
      0.408370,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.600869,
      2,
      1.234536,
      NULL,
      NULL,
      NULL,
      9.602657,
      9,
      0.259047,
      NULL,
      8.933189,
      8,
      1,
      1,
      0.557844,
      0.102692,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.627134,
      NULL,
      1,
      NULL,
      1.851258,
      0,
      1.025356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232665,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022925,
      4,
      NULL,
      5.861360,
      NULL,
      NULL,
      1.794768,
      NULL,
      NULL,
      NULL,
      1.406937,
      4.598915,
      0.489392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.633743,
      0,
      1,
      0,
      2,
      1,
      NULL,
      3.589008,
      0,
      NULL,
      0.656486,
      0.232923,
      0.173868,
      1.322626,
      1.573600,
      1,
      1,
      1.304465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      1.313608,
      '',
      '',
      '',
      1.303026,
      '',
      '',
      NULL,
      5,
      3,
      3,
      2,
      3,
      NULL,
      2.414245,
      1.481885,
      0.688076);
commit;
end;
/


