set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0424',
      '24332122',
      61,
      NULL,
      NULL,
      NULL,
      1,
      2.959056,
      1,
      NULL,
      NULL,
      '10-26-1985',
      NULL,
      45.141642,
      1,
      NULL,
      NULL,
      0,
      3,
      0.272332,
      0.439887,
      1,
      1.295969,
      NULL,
      0.533749,
      0.390391,
      1.019682,
      1,
      1.802270,
      NULL,
      1.346237,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      1.111976,
      4.088185,
      1,
      3.497587,
      NULL,
      0.691256,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.681957,
      0.791026,
      0.778943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0,
      6,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      1.859278,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361409,
      1.352425,
      NULL,
      1,
      1.730497,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1.306792,
      1.573597,
      0.903882,
      NULL,
      1.446670,
      3.029569,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.229746,
      2.869934,
      1,
      5.977873,
      NULL,
      NULL,
      2.304066,
      0,
      9.905839,
      NULL,
      7.635391,
      NULL,
      1,
      0.617177,
      1.507472,
      3.200751,
      NULL,
      1.806166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524977,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0.481059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178181,
      1.831295,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779359,
      3.423607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971012,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0.303813,
      NULL,
      1,
      NULL,
      1,
      1.056508,
      NULL,
      1,
      1,
      1.977727,
      1.927440,
      0.003583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.737026,
      '42434',
      '',
      '',
      1.904494,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      4.938504,
      2,
      3.690221,
      NULL,
      3.308615,
      NULL,
      1,
      2,
      0);
commit;
end;
/


