set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3240',
      '12111240',
      27,
      59.920988,
      '1231423',
      29.723850,
      1,
      1,
      3,
      '402100',
      NULL,
      '10-26-1983',
      82.024139,
      58.524120,
      NULL,
      NULL,
      2,
      0,
      3,
      0.455426,
      0.147829,
      1.903290,
      1,
      1.034656,
      0,
      0,
      NULL,
      1,
      0.494881,
      NULL,
      1.997832,
      4.639785,
      NULL,
      0,
      0.673071,
      1.086879,
      0,
      1.543838,
      7,
      1,
      5.128855,
      1.621050,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.721167,
      0.192460,
      1.933968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402598,
      NULL,
      1.830619,
      0.402010,
      NULL,
      NULL,
      1,
      1.928526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.725671,
      NULL,
      1,
      1,
      0.433810,
      0,
      1,
      1.345147,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.304396,
      1.939890,
      1,
      NULL,
      1.655517,
      NULL,
      1.825464,
      NULL,
      NULL,
      NULL,
      1,
      0.362366,
      3,
      1,
      NULL,
      1.017582,
      0.653772,
      0.558065,
      2,
      2.329351,
      0,
      NULL,
      NULL,
      9.227799,
      8.140382,
      0.888301,
      2,
      7,
      6.128824,
      3.032519,
      8,
      1,
      0.403427,
      1.435012,
      2.134919,
      1.192310,
      0.508722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.783411,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656744,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197480,
      1,
      0.512418,
      NULL,
      0.754863,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.310739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854653,
      1,
      NULL,
      1,
      1.820401,
      0.875137,
      3.004157,
      1,
      1.423002,
      3,
      1.912377,
      1,
      1.180748,
      0,
      1.289867,
      1.123115,
      NULL,
      1.944122,
      1,
      1.176093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      0.851301,
      '',
      '',
      '',
      0.769840,
      NULL,
      '',
      '',
      5,
      1.674601,
      3.044840,
      2,
      2,
      3.883850,
      3,
      3.947691,
      3);
commit;
end;
/


