set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '21012342',
      64.475529,
      60,
      '4000120',
      7,
      4,
      1.162429,
      0,
      '431421',
      2.512919,
      ' 3-15-1990',
      63.231375,
      58.990564,
      0,
      NULL,
      1,
      1.191575,
      1.451851,
      1.168137,
      1.539599,
      1.690497,
      1,
      3.889485,
      1,
      1.742149,
      0,
      0.453573,
      3,
      0.189361,
      NULL,
      1.439209,
      5,
      0,
      NULL,
      NULL,
      5,
      1.446740,
      NULL,
      NULL,
      5.337222,
      2,
      0,
      0,
      NULL,
      NULL,
      1.940472,
      NULL,
      NULL,
      2.383856,
      1.622176,
      1.206317,
      NULL,
      NULL,
      0.841530,
      1,
      NULL,
      0.969420,
      2.741434,
      NULL,
      1.366961,
      0,
      1,
      1.028591,
      1,
      0.381490,
      0.774957,
      0,
      NULL,
      0.228053,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.966526,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.561374,
      NULL,
      0.027749,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.960867,
      1,
      NULL,
      1,
      1,
      1.775079,
      NULL,
      1,
      1,
      0.573778,
      NULL,
      NULL,
      1,
      0,
      1.159868,
      1.921821,
      NULL,
      1.283811,
      1.455072,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.471364,
      5.114064,
      1,
      0.969882,
      6.003571,
      7,
      3.738929,
      NULL,
      NULL,
      1.706179,
      9.055173,
      1,
      1,
      5,
      NULL,
      2,
      0,
      1.702421,
      0.933982,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689224,
      1,
      1,
      NULL,
      NULL,
      0.759244,
      NULL,
      1.256172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098991,
      NULL,
      0.256425,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795250,
      3,
      6.473323,
      NULL,
      5.699228,
      0,
      0.456016,
      NULL,
      NULL,
      NULL,
      1,
      1.283706,
      0.625938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.495721,
      NULL,
      3.183638,
      3.697745,
      1.808644,
      NULL,
      0.361547,
      0,
      0.869861,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.922714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.811197,
      3,
      1.978087,
      2,
      0.680689,
      3,
      0,
      0,
      3.672773);
commit;
end;
/


