set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2240',
      '34013014',
      NULL,
      59.365009,
      '4144103',
      30,
      2,
      1.715514,
      3,
      '020423',
      2,
      ' 9-13-1991',
      241,
      NULL,
      1.755238,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.659702,
      0,
      3.880280,
      2.633160,
      NULL,
      0,
      1.837580,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1.487106,
      1.406294,
      1.030384,
      1.972690,
      1.660990,
      1.446307,
      NULL,
      1.498553,
      1,
      0,
      1,
      NULL,
      NULL,
      1.853063,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333879,
      1.682323,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.981859,
      1.234769,
      0,
      1.084018,
      1.127943,
      0,
      NULL,
      0.016699,
      1.998231,
      0.329623,
      0,
      1.038686,
      0.849520,
      0.301593,
      NULL,
      0,
      NULL,
      0.611037,
      0,
      0.920406,
      1,
      0,
      1.079652,
      0,
      1.719290,
      1,
      1.900310,
      0,
      0,
      1.476351,
      1,
      0.683516,
      3,
      2.105372,
      NULL,
      1,
      2,
      1.340667,
      0.128248,
      5,
      1,
      5.935689,
      1.435429,
      1.308320,
      NULL,
      NULL,
      NULL,
      1.542377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.410703,
      0,
      0,
      0.522641,
      1.434943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797250,
      0.098498,
      1.066550,
      2.379344,
      0,
      1,
      1.469824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.656200,
      0,
      1,
      1,
      0.013943,
      1,
      0.786787,
      0.787192,
      1.600878,
      0,
      0,
      NULL,
      1,
      0.576245,
      0,
      NULL,
      0,
      1.228805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '43432',
      NULL,
      '',
      0,
      1,
      3,
      NULL,
      0.675225,
      NULL,
      NULL,
      1,
      3);
commit;
end;
/


