set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2402',
      NULL,
      NULL,
      10,
      '2204410',
      80,
      0,
      0,
      0,
      NULL,
      1.868982,
      ' 8-26-1983',
      21,
      59.228787,
      1.219894,
      NULL,
      0,
      NULL,
      1,
      1.768651,
      1,
      1.528799,
      0.705733,
      NULL,
      0.256220,
      1,
      5.992415,
      0,
      1,
      NULL,
      1.339298,
      NULL,
      2,
      0,
      0.316935,
      0.397678,
      0,
      1.671766,
      2,
      NULL,
      0.417202,
      1.549277,
      0.877661,
      NULL,
      NULL,
      NULL,
      1.982377,
      NULL,
      NULL,
      1.261202,
      0,
      0,
      0.513365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.129917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.084168,
      0,
      1.077167,
      1.813317,
      0,
      1.466235,
      0.429310,
      0,
      1,
      1,
      1.663726,
      0,
      1,
      0,
      1.287021,
      0,
      NULL,
      0,
      1,
      0.650694,
      0.159448,
      1,
      1.440367,
      0,
      0,
      0.766337,
      NULL,
      1.981492,
      4.863608,
      1,
      0,
      0,
      1.379091,
      1,
      1.052372,
      0.681022,
      NULL,
      NULL,
      1.704812,
      2,
      2.063311,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.632161,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      0.151627,
      0.829761,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051887,
      0,
      2,
      0.275246,
      2,
      1.836665,
      NULL,
      NULL,
      NULL,
      0.959781,
      1,
      0.497752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008383,
      3.150570,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      2.063691,
      0,
      1.858632,
      NULL,
      1,
      1.581606,
      1.640663,
      1,
      0,
      0,
      0.457256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.213146,
      '32224',
      '',
      '',
      0.528785,
      '',
      '',
      '',
      1.523686,
      '02124',
      '',
      '',
      3,
      2.963123,
      NULL,
      2.432788,
      NULL,
      0.140464,
      0.514506,
      3.768330,
      1);
commit;
end;
/


