set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1410',
      NULL,
      75,
      38.279243,
      '0201323',
      21,
      NULL,
      NULL,
      3,
      '000420',
      0.192760,
      ' 7-14-1992',
      19,
      29,
      NULL,
      NULL,
      1,
      1,
      1,
      1.227613,
      1.202367,
      1.160083,
      0,
      1.514971,
      NULL,
      1.755813,
      0.490518,
      1.978450,
      0,
      NULL,
      0,
      1,
      1.276945,
      1.002894,
      1.924394,
      NULL,
      1,
      0,
      5,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.169504,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291956,
      0.926870,
      1.113157,
      1.343294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359564,
      NULL,
      0.479579,
      NULL,
      1.244178,
      1,
      1,
      1.920390,
      1,
      0.409998,
      3.703696,
      0.062983,
      1,
      NULL,
      1.798726,
      0.037630,
      0.642154,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0.861843,
      1,
      1.931837,
      0,
      0.364183,
      0.497111,
      1,
      NULL,
      0.850382,
      1.804482,
      0,
      2,
      0.196339,
      0,
      NULL,
      1.944966,
      NULL,
      4.970989,
      NULL,
      0.214258,
      1.109544,
      1.247220,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      0,
      1.042659,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511343,
      NULL,
      8.011821,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.983208,
      1,
      2.435513,
      0.699725,
      1,
      1,
      0,
      NULL,
      NULL,
      5.355391,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331914,
      3.373820,
      0.011466,
      NULL,
      0.727204,
      0,
      0,
      NULL,
      0.977265,
      0.106580,
      0,
      0,
      0,
      0.462814,
      1,
      0.274587,
      1,
      1,
      0.789662,
      0.317178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '02211',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      '40304',
      NULL,
      NULL,
      0.182299,
      2.913430,
      2.365036,
      3.838605,
      2.256633,
      3,
      0,
      3);
commit;
end;
/


