set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '4421201',
      12.940087,
      NULL,
      3,
      2,
      '301113',
      2.228895,
      ' 7-16-1985',
      19,
      NULL,
      0,
      NULL,
      1,
      3,
      0,
      1,
      1.136240,
      NULL,
      1,
      0.215121,
      0,
      1.320530,
      1.113611,
      0.753146,
      1,
      0.005685,
      NULL,
      0,
      1,
      0.952188,
      0,
      0,
      1.435284,
      1.850478,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.771869,
      1.091179,
      2,
      NULL,
      0.966651,
      NULL,
      NULL,
      2.252583,
      1,
      2.722820,
      NULL,
      1.940978,
      1.557047,
      1.374080,
      2,
      0.605927,
      0.546259,
      0.194467,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.427946,
      0.087525,
      NULL,
      1,
      1,
      0.306644,
      NULL,
      1.761801,
      1.098219,
      1,
      0,
      0,
      NULL,
      1.044956,
      1.303555,
      1.692608,
      1.579248,
      NULL,
      1,
      NULL,
      0.634538,
      0,
      0.054462,
      3,
      0.645821,
      0.637842,
      0.127456,
      4,
      NULL,
      1.228038,
      1.674138,
      NULL,
      NULL,
      3.429523,
      1.917839,
      1.053790,
      3.606441,
      NULL,
      1,
      0.995882,
      0.458857,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.255761,
      NULL,
      NULL,
      2.817107,
      2.765836,
      7.963738,
      0,
      NULL,
      0.486516,
      0.289336,
      3,
      0,
      2,
      0.940667,
      NULL,
      NULL,
      NULL,
      0.105886,
      5,
      1.327193,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105025,
      0.487245,
      NULL,
      1.434797,
      2,
      0.747445,
      1.723533,
      2.118132,
      1,
      0,
      0,
      2.294491,
      0.719684,
      1.422191,
      1.271214,
      1.588994,
      0,
      0,
      NULL,
      0,
      1.526085,
      2,
      0,
      0.336221,
      1.062711,
      2,
      3.929132,
      NULL,
      1.096965,
      0.334156,
      0.965533,
      0.154554,
      NULL,
      1.868794,
      1.604600,
      0.538396,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '12330',
      '12112',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


