set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      '00',
      0.985037,
      4.573591,
      '3104133',
      4,
      1,
      3.431621,
      1,
      '310013',
      NULL,
      ' 0-15-2000',
      21,
      3.135906,
      0.288688,
      NULL,
      1,
      0,
      1.009131,
      NULL,
      0.748763,
      0.400550,
      0.194862,
      1,
      3,
      NULL,
      1,
      1.847352,
      0,
      0.574099,
      1,
      1,
      NULL,
      1.245638,
      1.695278,
      0.260720,
      1.666782,
      0.640248,
      0.802239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      4.972851,
      1,
      0,
      0,
      0.780990,
      1,
      1,
      3.281860,
      NULL,
      NULL,
      3,
      2.127865,
      NULL,
      1.432798,
      NULL,
      1,
      1,
      1.729928,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.493897,
      1,
      1,
      0.161733,
      NULL,
      1.294676,
      1.006145,
      0,
      1,
      1.550863,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1.118981,
      1.560884,
      NULL,
      1,
      0,
      1.056405,
      NULL,
      NULL,
      0.606013,
      NULL,
      0.833173,
      2,
      0.740497,
      3.566865,
      0,
      1.116668,
      1.916138,
      7.058941,
      0.592843,
      1.083816,
      5.966985,
      NULL,
      5,
      4.033827,
      2.816164,
      6.861365,
      0,
      4.155112,
      3.641181,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.984438,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.332215,
      1,
      1,
      0,
      1.350548,
      0.152045,
      1.214903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      2.765688,
      2.373521,
      1.021469,
      0.850362,
      2,
      NULL,
      NULL,
      NULL,
      2,
      0.139740,
      NULL,
      NULL,
      NULL,
      1.156445,
      5,
      NULL,
      3.956928,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.964956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.842993,
      1,
      0,
      NULL,
      3,
      0,
      0,
      0.538924,
      2.963634,
      3,
      2.332935,
      0.521636,
      0,
      0,
      0,
      0.798203,
      1.890988,
      1,
      0,
      NULL,
      0.406574,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1,
      0,
      1,
      0.216011,
      1.816480,
      0.113887,
      NULL,
      0.840958,
      1,
      1.686317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.923375,
      '01232',
      '31124',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.324645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


