set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      25.587559,
      NULL,
      '2430424',
      33.012037,
      6,
      1.374141,
      1,
      '313421',
      0.082655,
      ' 5- 9-1977',
      NULL,
      59.382183,
      1.278050,
      NULL,
      1,
      1,
      1,
      0,
      0.350142,
      0,
      NULL,
      1,
      1.864123,
      0,
      5.167257,
      0,
      0,
      1,
      0.010430,
      NULL,
      2,
      0.820335,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      4,
      1,
      1,
      1.763562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      1,
      NULL,
      NULL,
      0.204435,
      1,
      NULL,
      NULL,
      2,
      1,
      2.165360,
      1.541410,
      NULL,
      2,
      3,
      0.124583,
      NULL,
      0.560769,
      NULL,
      1.800237,
      NULL,
      3.846713,
      1,
      0,
      1,
      1.062621,
      0,
      NULL,
      NULL,
      0.347590,
      NULL,
      NULL,
      0,
      NULL,
      0.351549,
      1,
      NULL,
      1,
      0,
      0.540558,
      1,
      1,
      NULL,
      NULL,
      1,
      0.448476,
      1,
      0,
      1,
      0,
      0.985998,
      NULL,
      0,
      NULL,
      0.724594,
      1.422301,
      2.150822,
      1.470953,
      1,
      0.340910,
      7,
      1.730077,
      2.258894,
      NULL,
      NULL,
      0,
      2,
      1.446077,
      NULL,
      NULL,
      6.886648,
      8.861340,
      5,
      NULL,
      NULL,
      NULL,
      2.346131,
      0,
      5.074722,
      2,
      1,
      0.362017,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0.805790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1.947518,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.727804,
      NULL,
      0,
      NULL,
      1,
      2,
      5,
      0.560252,
      1.602215,
      5.650023,
      5,
      2,
      NULL,
      1.282248,
      NULL,
      NULL,
      1.308191,
      9.266398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.356610,
      3.079893,
      1.825633,
      0.918086,
      2,
      0.564947,
      2.139690,
      NULL,
      1,
      NULL,
      2,
      0.263062,
      1,
      1,
      NULL,
      NULL,
      0.034921,
      1,
      0,
      1,
      0,
      0.139572,
      0,
      0.533919,
      2.930374,
      1.510234,
      NULL,
      1.504278,
      NULL,
      0.914900,
      0,
      0.762591,
      1,
      1,
      NULL,
      0.399865,
      1.885077,
      0.594717,
      1,
      1.454720,
      0,
      3,
      0.687939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511753,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850338,
      0,
      NULL,
      NULL,
      0.011527,
      NULL,
      NULL,
      1,
      1.200782,
      NULL,
      '34324',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.956310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


