set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      19.756145,
      '1142214',
      2.816740,
      0,
      1.784372,
      3,
      '014111',
      2,
      NULL,
      47,
      NULL,
      1,
      NULL,
      1.968632,
      NULL,
      1,
      1,
      1.035131,
      1.977943,
      0.746168,
      NULL,
      2,
      1.979444,
      4.412563,
      0,
      NULL,
      0,
      NULL,
      0,
      7.788462,
      0.789883,
      1,
      1,
      NULL,
      0.173912,
      3,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      6,
      NULL,
      0,
      NULL,
      2.322566,
      1,
      NULL,
      NULL,
      3.267838,
      NULL,
      NULL,
      3,
      1.165540,
      1.298270,
      1,
      0.137421,
      0.872576,
      1,
      0.686466,
      4,
      1,
      1,
      2,
      0.681442,
      NULL,
      NULL,
      NULL,
      0.387185,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.593201,
      0.495227,
      1.965643,
      0.100349,
      1,
      1.756412,
      0.704868,
      NULL,
      1,
      1.475849,
      0.575992,
      1.137248,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.521706,
      5.894066,
      1,
      0.857302,
      0,
      0,
      5,
      1.603873,
      NULL,
      4,
      3.974896,
      3.957290,
      0,
      0,
      5.488042,
      0,
      3.882349,
      NULL,
      7.980737,
      2,
      0.356800,
      1.773950,
      0,
      NULL,
      1,
      4.239334,
      3,
      1.081400,
      3,
      1.320323,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076019,
      1,
      0,
      0,
      0,
      0,
      0.812329,
      0.181446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      NULL,
      1,
      6.198808,
      1,
      3,
      0,
      1,
      3.180635,
      3,
      1,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      3.437190,
      4.350781,
      NULL,
      0,
      1.703088,
      NULL,
      NULL,
      NULL,
      0.346742,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      1.856251,
      3,
      1.593575,
      0,
      1.086034,
      3.886888,
      NULL,
      3.384547,
      NULL,
      NULL,
      NULL,
      0,
      1.439154,
      0.443925,
      1,
      NULL,
      1,
      3,
      0.376716,
      1,
      1,
      1.147652,
      3.025397,
      1,
      0.650593,
      0,
      0,
      0,
      1,
      0.954667,
      0.709590,
      1,
      NULL,
      0,
      1.370355,
      0,
      1.942549,
      1.912090,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861265,
      NULL,
      1.058357,
      NULL,
      0,
      NULL,
      1,
      0.872893,
      3,
      0,
      0,
      NULL,
      0.899252,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.972767,
      NULL,
      0,
      1,
      1,
      0,
      3,
      '40020',
      '22411',
      '',
      0.600356,
      '',
      '',
      '',
      0,
      '3103',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


