set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '04',
      NULL,
      1.562522,
      '2200104',
      50.789831,
      NULL,
      NULL,
      2,
      '441240',
      0.958283,
      ' 6- 1-1984',
      52.989210,
      73.901813,
      NULL,
      NULL,
      1.275739,
      NULL,
      1.689652,
      0.412332,
      1,
      1,
      1,
      0.244177,
      1,
      NULL,
      1.705591,
      1.607458,
      0.567605,
      1,
      1.903796,
      1,
      NULL,
      1.136056,
      1.923938,
      0,
      1,
      1.863318,
      3.867789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0.200466,
      NULL,
      2.903376,
      1.418282,
      2.812819,
      1.706968,
      1.188122,
      1,
      2,
      3,
      0,
      0,
      1.931380,
      1.107392,
      NULL,
      2,
      1.685151,
      1.223880,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.667729,
      NULL,
      NULL,
      1.647408,
      0.728660,
      NULL,
      0.898525,
      1.095133,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1.502866,
      1,
      0.776636,
      1,
      0.958103,
      1,
      NULL,
      0,
      1,
      NULL,
      1.639481,
      1,
      1.307179,
      NULL,
      1,
      0,
      0.562014,
      0.647468,
      NULL,
      1,
      NULL,
      NULL,
      0.494955,
      1,
      3,
      5,
      2.000317,
      0.160344,
      1,
      NULL,
      0,
      5.173720,
      3.817420,
      1.725111,
      1,
      0,
      NULL,
      NULL,
      5,
      0.685452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365909,
      0,
      1,
      0.701276,
      0,
      0.684422,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.685839,
      0,
      2,
      NULL,
      2,
      NULL,
      0.672829,
      NULL,
      NULL,
      0.891243,
      4.561258,
      NULL,
      0.927126,
      NULL,
      NULL,
      NULL,
      1.672928,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.806491,
      0.979771,
      1.585255,
      3,
      0,
      NULL,
      2,
      1.780831,
      3.932702,
      0,
      1.788690,
      1.722397,
      0,
      NULL,
      NULL,
      1,
      0.395049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651235,
      0.957001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910651,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440643,
      0.760735,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1.851259,
      '01443',
      '40000',
      '',
      0.375671,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0.883347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


