set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10010412',
      NULL,
      NULL,
      '4131041',
      28,
      5,
      NULL,
      1,
      '433043',
      3.541920,
      ' 2-22-1991',
      28,
      NULL,
      0.320603,
      NULL,
      1.637650,
      0,
      0.620253,
      NULL,
      0,
      1,
      0,
      NULL,
      0.962165,
      1,
      1.366122,
      1.073939,
      NULL,
      1,
      1.172370,
      0,
      2,
      1.987265,
      0,
      0.440373,
      NULL,
      NULL,
      5.886408,
      0,
      3,
      1,
      1,
      0.594640,
      NULL,
      NULL,
      0.329459,
      NULL,
      NULL,
      2,
      1.247386,
      0.263790,
      1.303935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870046,
      0.957915,
      1,
      4,
      0,
      0,
      1,
      0.797334,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.796739,
      1.314721,
      0,
      1.145531,
      1.195770,
      0.580158,
      NULL,
      0,
      1.206125,
      0.290530,
      1,
      NULL,
      0,
      1.669926,
      1,
      0.069885,
      0.697529,
      1,
      0.414804,
      NULL,
      1.119764,
      3.539792,
      0,
      1,
      0.773423,
      0.464441,
      3.047773,
      1.179718,
      2,
      NULL,
      4,
      3,
      NULL,
      0.096294,
      2.400535,
      1,
      0,
      0,
      3.322190,
      5.146870,
      4.071583,
      2,
      NULL,
      3.828352,
      NULL,
      NULL,
      5.898901,
      1.493511,
      NULL,
      NULL,
      NULL,
      8,
      0.481731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823875,
      NULL,
      1,
      0,
      1.633901,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.520787,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.294513,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258089,
      1,
      1.007627,
      5.437849,
      0.266021,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959680,
      1.052223,
      0.060182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.322565,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      3,
      1,
      NULL,
      1.824374,
      1.846983,
      0,
      1.993178,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.649767,
      '43044',
      '24320',
      '02024',
      1.635104,
      '',
      NULL,
      '',
      0.202421,
      '',
      '',
      '',
      5,
      0.887613,
      NULL,
      3,
      3.919636,
      1,
      0,
      3,
      5.147318);
commit;
end;
/


