set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '240',
      '42234322',
      7.257683,
      60,
      NULL,
      133.345991,
      2,
      2,
      0,
      NULL,
      2.767353,
      NULL,
      13.292141,
      55.354087,
      1.808747,
      NULL,
      NULL,
      1,
      1,
      1,
      1.161472,
      NULL,
      0.392500,
      NULL,
      NULL,
      1.024322,
      NULL,
      0,
      1.088813,
      0,
      0,
      0,
      1.425280,
      0.043608,
      0,
      1,
      NULL,
      0.538799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.488793,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.058719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.854335,
      NULL,
      1.876816,
      NULL,
      1.262694,
      1.993181,
      0.329800,
      1.380806,
      0,
      NULL,
      1.444184,
      1.287550,
      1.206045,
      1.712071,
      0.118811,
      NULL,
      1.803457,
      NULL,
      NULL,
      0,
      1.032761,
      0,
      4.211799,
      0,
      4.121288,
      0.693066,
      5.669849,
      2.530284,
      0,
      0,
      NULL,
      1.315216,
      NULL,
      NULL,
      5,
      4.977005,
      NULL,
      4,
      NULL,
      2.152864,
      0.131525,
      NULL,
      0.795101,
      3,
      1.505223,
      NULL,
      NULL,
      5,
      0.389664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431005,
      0,
      NULL,
      NULL,
      NULL,
      0.545050,
      1.162334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.639757,
      2.704404,
      1.473895,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.116214,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.586449,
      0.006201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585655,
      NULL,
      0,
      1,
      NULL,
      3.169954,
      1,
      NULL,
      0.100644,
      0,
      1.829277,
      0,
      1,
      0,
      0.010248,
      1,
      0,
      0,
      1,
      0.141331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.214905,
      '22024',
      '11004',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      5.122176,
      0.006949,
      NULL,
      7.979594,
      NULL,
      3.426229,
      3.877012,
      1,
      1);
commit;
end;
/


