set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '12424421',
      76.395442,
      NULL,
      '0032031',
      55.078802,
      0,
      3.103812,
      2,
      '221334',
      5,
      ' 9-12-1992',
      10,
      NULL,
      0,
      NULL,
      0.724791,
      0,
      NULL,
      0.403195,
      1.384618,
      1.161100,
      0.091018,
      NULL,
      0.006199,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0.503380,
      1,
      1,
      NULL,
      1.957759,
      0,
      1.209549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.487690,
      1,
      1.311019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203490,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.947720,
      1.006846,
      0,
      0.487563,
      1,
      0,
      0,
      0.520539,
      NULL,
      1.743008,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0.120927,
      NULL,
      0.124189,
      1.450503,
      0,
      NULL,
      1,
      0.643291,
      1,
      3.456139,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.333998,
      1,
      0.536850,
      0,
      NULL,
      2.181343,
      NULL,
      5,
      0,
      2,
      0,
      NULL,
      NULL,
      4.810911,
      2,
      1,
      NULL,
      NULL,
      6,
      1.868928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535140,
      1,
      0,
      1,
      0.100129,
      1,
      0.296810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427609,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866532,
      NULL,
      3.975330,
      1,
      1,
      1.413629,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.839053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743801,
      0.517113,
      1.757540,
      NULL,
      0.813378,
      3.876232,
      0.889861,
      NULL,
      1,
      0.134764,
      NULL,
      0.069092,
      0.654045,
      1,
      0.639679,
      1.193187,
      1.334889,
      0.529947,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.848231,
      '41014',
      '24041',
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1.191195,
      2,
      1.739413,
      NULL,
      3.438727,
      1,
      3,
      3,
      3.109371);
commit;
end;
/


