set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      NULL,
      13,
      NULL,
      '0032240',
      NULL,
      4,
      1.687047,
      2,
      '304033',
      1,
      ' 5-24-1978',
      5.479158,
      27,
      1.372077,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1.291470,
      3,
      NULL,
      0,
      3.882374,
      0,
      0,
      0,
      1,
      1.930690,
      1.361420,
      1,
      NULL,
      0,
      3.013017,
      1.416271,
      1,
      1.696579,
      1,
      0,
      NULL,
      1.216657,
      3.970679,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      5.869726,
      2.518797,
      0,
      NULL,
      0,
      2.740669,
      2.850155,
      0.108701,
      1,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      0,
      2.469342,
      0.667482,
      0.959337,
      NULL,
      7.924416,
      1,
      NULL,
      0.357721,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774291,
      NULL,
      1.356148,
      0.020680,
      1.733438,
      0.423023,
      0.079081,
      1.604987,
      1.749278,
      1.051905,
      1.350411,
      1,
      1.642919,
      1,
      0.866033,
      1,
      1.144025,
      1,
      0.423919,
      NULL,
      1.177948,
      0.528236,
      1.591215,
      0,
      NULL,
      0.383903,
      NULL,
      1,
      2.335100,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0.883921,
      1.444112,
      0.788898,
      7.349087,
      3.169376,
      0,
      2,
      3,
      3,
      5,
      3.897124,
      1,
      NULL,
      1.903242,
      0,
      0,
      6,
      1.765598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.752797,
      1,
      NULL,
      1.191616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.656622,
      NULL,
      7.396803,
      2.214015,
      1.002273,
      4,
      0.038782,
      1,
      NULL,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521997,
      1.249797,
      4,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      1.035340,
      0,
      1,
      1,
      0,
      NULL,
      0.884455,
      0.600857,
      0.511064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.153342,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


