set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      '44',
      10,
      16.738205,
      '3230442',
      19.369740,
      1,
      2.497919,
      1,
      '302022',
      0,
      '11-24-1998',
      36.087500,
      115.853658,
      0,
      NULL,
      1.168980,
      0.811779,
      NULL,
      0,
      0.345459,
      NULL,
      1.708887,
      0,
      3.014876,
      0.141790,
      0,
      1.713605,
      0,
      0,
      1,
      1.479203,
      1.383853,
      1.163201,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.042375,
      3.362885,
      0,
      0,
      0,
      3.820076,
      1.273219,
      1,
      1,
      3.117390,
      0.996089,
      3.747671,
      1,
      2.660413,
      1,
      3.102650,
      1.763259,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      0.253259,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1.242803,
      1,
      1,
      0.336296,
      0,
      0,
      1,
      1,
      1.574979,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.660060,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.267983,
      1,
      NULL,
      0.089526,
      NULL,
      0.120134,
      NULL,
      0.153824,
      7,
      4.613873,
      1.761334,
      2.126025,
      2,
      5.206043,
      2,
      1,
      4.542411,
      NULL,
      1.515188,
      1,
      6,
      0.346765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.704259,
      0,
      1.804516,
      0.494883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317609,
      2,
      1.944756,
      NULL,
      NULL,
      NULL,
      2.847892,
      0,
      5,
      4,
      0,
      0,
      1.793466,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878508,
      0,
      0.063305,
      0.134587,
      NULL,
      1,
      0.641478,
      3.589770,
      0.128700,
      0.980109,
      0.573145,
      1.148972,
      1.611386,
      0,
      0.323559,
      0,
      0.179172,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '21111',
      '',
      '',
      1.129946,
      NULL,
      '',
      '',
      2,
      '3012',
      '',
      '',
      1.533779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


