set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      NULL,
      22,
      NULL,
      '0301240',
      43,
      6,
      3,
      3,
      '331000',
      NULL,
      ' 0-22-1994',
      NULL,
      43.715026,
      1,
      NULL,
      1,
      0.921317,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1.186812,
      NULL,
      3.399074,
      5.129239,
      0,
      0.645910,
      1,
      0,
      1.691843,
      0,
      0.445508,
      5.041654,
      1,
      2,
      NULL,
      1,
      0.365341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0,
      1.584725,
      1,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      2.051456,
      1.562014,
      0,
      0,
      0,
      NULL,
      0.681424,
      0,
      6,
      1,
      1.441631,
      5.901340,
      1,
      0,
      1,
      1.155499,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.078424,
      0.821192,
      0,
      0,
      1.400052,
      1,
      NULL,
      1.236548,
      NULL,
      1,
      1.384329,
      NULL,
      0.963781,
      0.614347,
      1.590840,
      0,
      1.913028,
      0.100331,
      1.830722,
      NULL,
      1.188857,
      0.044096,
      0.219236,
      0,
      1.770982,
      0.868016,
      NULL,
      0.652152,
      1.792650,
      0.159470,
      1,
      1.053662,
      1,
      NULL,
      0.150515,
      0.088082,
      1,
      NULL,
      NULL,
      2.612250,
      4,
      4.331866,
      3.626860,
      0,
      0,
      0,
      NULL,
      NULL,
      3.881948,
      1.552869,
      0,
      NULL,
      0.050790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.182593,
      0.475103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.404080,
      NULL,
      5.204541,
      3,
      1.923130,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.070666,
      NULL,
      1,
      6,
      1.171564,
      NULL,
      NULL,
      NULL,
      3.344095,
      1.501852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.202085,
      1,
      0.441533,
      NULL,
      NULL,
      1.272656,
      1.059660,
      0,
      0.896850,
      2,
      1,
      0,
      0,
      0.933187,
      0,
      0,
      NULL,
      0,
      NULL,
      1.053724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.348715,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '3424',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


