set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      NULL,
      NULL,
      11,
      '1144301',
      9,
      2,
      NULL,
      1,
      NULL,
      0.534024,
      ' 9- 5-1991',
      NULL,
      30,
      1.595226,
      NULL,
      NULL,
      0.200273,
      1,
      NULL,
      0,
      0.398294,
      1,
      0.214771,
      1.217156,
      0.178667,
      4.239129,
      1.563397,
      1.175099,
      1.822989,
      NULL,
      NULL,
      2.440673,
      3.472365,
      NULL,
      0,
      6.941271,
      NULL,
      5.729177,
      1,
      NULL,
      1,
      2,
      1.968741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.357048,
      7,
      7,
      NULL,
      0,
      1.956766,
      1.269648,
      1.726512,
      1.143264,
      NULL,
      3.368364,
      2.100802,
      0.298526,
      0,
      2,
      NULL,
      2,
      NULL,
      2.387479,
      7.219871,
      0.967420,
      1.826344,
      8.427921,
      2,
      2,
      0,
      0.141100,
      NULL,
      NULL,
      0.157562,
      NULL,
      NULL,
      1,
      1.822351,
      0.689289,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.958207,
      0,
      1,
      0,
      0.909817,
      NULL,
      0,
      0.258398,
      1,
      0.558341,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570713,
      0.424051,
      NULL,
      0.057261,
      1,
      1.268952,
      0.692096,
      1.454250,
      0.528795,
      1,
      NULL,
      NULL,
      1.507130,
      0,
      NULL,
      2.595042,
      1.027896,
      3,
      NULL,
      1.519676,
      2,
      NULL,
      0.162261,
      0,
      1.051738,
      0,
      0.623712,
      1.062505,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.615192,
      0.008787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.403335,
      0.060688,
      NULL,
      NULL,
      NULL,
      0.335689,
      1.316728,
      5.168578,
      1,
      1.762506,
      NULL,
      1.106217,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.899393,
      NULL,
      1.902373,
      0,
      0.934360,
      1,
      0.831123,
      NULL,
      0.773290,
      3.491915,
      1,
      1,
      0,
      1,
      1.474884,
      1,
      0.364519,
      1.664659,
      1.773724,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '33433',
      '',
      '',
      0.953488,
      '',
      NULL,
      '',
      1.785917,
      '2023',
      '',
      '',
      4,
      1,
      1.895998,
      1,
      0.839844,
      5,
      3.111239,
      1,
      3.461940);
commit;
end;
/


