set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      NULL,
      21.190452,
      17,
      '3323224',
      29.142016,
      3,
      3.317401,
      0,
      '410142',
      6,
      NULL,
      38,
      24.162488,
      1,
      NULL,
      NULL,
      0.758904,
      2.022514,
      0,
      1.830875,
      0.233804,
      0.264746,
      NULL,
      0.460670,
      1.325955,
      1,
      1,
      NULL,
      0,
      0.191540,
      1.661288,
      NULL,
      1,
      0.269357,
      0,
      0.319664,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.869436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576145,
      1.523900,
      1,
      1.748673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858227,
      1.214408,
      NULL,
      NULL,
      1,
      1.065849,
      0,
      0.652569,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.298782,
      1,
      NULL,
      0,
      0,
      1.755443,
      NULL,
      0.490440,
      1,
      NULL,
      1,
      0,
      1,
      1.942001,
      1.654583,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992081,
      0.934334,
      0,
      1,
      1,
      NULL,
      2,
      1.797754,
      6,
      4.435630,
      3.843436,
      0.579100,
      NULL,
      NULL,
      0.386133,
      0.762001,
      1.490397,
      NULL,
      NULL,
      0.329087,
      1.217937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532425,
      1,
      0,
      0,
      NULL,
      0,
      0.529826,
      0.342790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3.503453,
      1,
      NULL,
      1.409573,
      1,
      NULL,
      1.464960,
      0,
      0.931475,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.469720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233415,
      0,
      0,
      0,
      NULL,
      1.806123,
      1,
      0.804619,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.326422,
      NULL,
      1.997165,
      1.343518,
      0.200342,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '4401',
      '',
      NULL,
      0.246206,
      3.311511,
      NULL,
      1.026961,
      3,
      NULL,
      1,
      2.486090,
      1.537484);
commit;
end;
/


