set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '140',
      '33434003',
      NULL,
      38,
      '4101103',
      44.292630,
      2,
      1.875603,
      NULL,
      '223324',
      0.052666,
      ' 0-21-1985',
      38,
      38.003435,
      0,
      NULL,
      1.362367,
      1.139025,
      3.021802,
      0.322153,
      0,
      1,
      0.000348,
      0,
      NULL,
      0.155659,
      0.530906,
      1,
      1.455463,
      3,
      NULL,
      5,
      NULL,
      0.283830,
      1.414162,
      NULL,
      0,
      0,
      4,
      0,
      5.869840,
      2,
      1.538755,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.256395,
      1.160848,
      1.689174,
      3.337082,
      1,
      NULL,
      1.656680,
      0,
      0,
      1.671529,
      0.795834,
      1.895799,
      3.682308,
      2,
      3,
      1.813431,
      0,
      1,
      1.816799,
      2,
      1.767669,
      NULL,
      4,
      0,
      0,
      3.912166,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.640993,
      1,
      NULL,
      1.690079,
      1.175690,
      NULL,
      0,
      1.395149,
      NULL,
      NULL,
      1.444957,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.579192,
      1.234126,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.219233,
      1.608114,
      NULL,
      NULL,
      6.415455,
      7,
      NULL,
      3,
      NULL,
      5.340341,
      NULL,
      0,
      0,
      0,
      NULL,
      1.683014,
      1.891203,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194861,
      1.908527,
      1,
      0,
      NULL,
      1,
      1.722631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.278070,
      0,
      0,
      1.636960,
      2.191744,
      NULL,
      1.559574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2.937847,
      1.894017,
      0,
      NULL,
      1.871079,
      NULL,
      NULL,
      1,
      1.434480,
      1.421579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.921001,
      0,
      2,
      2.472916,
      NULL,
      NULL,
      NULL,
      0,
      2.728592,
      0.652580,
      NULL,
      1.653886,
      1.522358,
      NULL,
      0.251650,
      NULL,
      1.124137,
      NULL,
      0.310814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '20403',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      3.678827,
      1.433792,
      2.773250,
      4,
      NULL,
      3,
      1.036391,
      1);
commit;
end;
/


