set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '12401401',
      36,
      50.001069,
      '2323333',
      97.862666,
      4,
      3.679673,
      2,
      '343342',
      4.583064,
      '11-25-1974',
      10,
      NULL,
      NULL,
      NULL,
      1.633674,
      NULL,
      0,
      1,
      0.092856,
      1.968064,
      3,
      0.076220,
      1.090851,
      NULL,
      1.718741,
      NULL,
      NULL,
      2,
      2.048206,
      NULL,
      7.526218,
      1,
      1,
      1.230330,
      2.023481,
      0,
      NULL,
      1,
      1.695619,
      3.676045,
      3.611957,
      1,
      NULL,
      NULL,
      0.613463,
      NULL,
      NULL,
      8.648438,
      6.710839,
      NULL,
      2,
      0.424123,
      1,
      3.898374,
      3.033393,
      0,
      3,
      0,
      2.566506,
      NULL,
      NULL,
      1,
      NULL,
      1.307976,
      NULL,
      NULL,
      6.699860,
      1,
      1.326559,
      2,
      NULL,
      0,
      2.933496,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      4.956090,
      NULL,
      NULL,
      0.490214,
      1,
      0.688695,
      0,
      0.629219,
      1.897807,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1.966672,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.600318,
      0.644239,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512852,
      1,
      0.392388,
      1,
      0,
      2,
      4.968187,
      4,
      2.134514,
      1.371573,
      0,
      NULL,
      2,
      1,
      NULL,
      0.701257,
      2.529855,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.726937,
      3.072765,
      0,
      NULL,
      NULL,
      NULL,
      0.407925,
      1,
      0,
      NULL,
      0,
      0,
      3.521659,
      1,
      NULL,
      NULL,
      1.284490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.784987,
      3.532339,
      1.238541,
      1,
      0,
      0.314939,
      2.389633,
      1.663293,
      1.416957,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.654821,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '00414',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0.583834,
      '3404',
      '',
      '',
      NULL,
      0,
      2.941158,
      0,
      0,
      5.901755,
      NULL,
      1,
      2.350143);
commit;
end;
/


