set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '00411234',
      47.783089,
      NULL,
      '2111010',
      65.270930,
      3,
      NULL,
      3,
      '244321',
      5.982445,
      ' 1- 5-1980',
      29.027239,
      32,
      1.422758,
      NULL,
      NULL,
      0,
      3,
      1.965990,
      1,
      1.772139,
      NULL,
      NULL,
      0.199594,
      1,
      1,
      0.242125,
      0.406582,
      4,
      1.681276,
      7.584570,
      6.226314,
      NULL,
      0,
      NULL,
      3.297127,
      NULL,
      0,
      0,
      3.772275,
      3,
      5.520534,
      NULL,
      NULL,
      NULL,
      0.840904,
      NULL,
      NULL,
      3.681415,
      8,
      0.912756,
      3,
      1,
      0.329944,
      NULL,
      NULL,
      3,
      3.317142,
      0,
      NULL,
      1.677326,
      NULL,
      1,
      2,
      NULL,
      2.521609,
      NULL,
      11.560328,
      NULL,
      NULL,
      8.741972,
      1,
      NULL,
      1.089097,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.389866,
      0.527511,
      0.154645,
      1.842716,
      0,
      1.489283,
      1,
      0,
      NULL,
      NULL,
      1.037775,
      1.133901,
      1.452644,
      1.400288,
      0,
      1.559572,
      NULL,
      0,
      NULL,
      0.547241,
      1,
      1.547904,
      NULL,
      0,
      1.320300,
      0,
      1.179833,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999418,
      0,
      1.234236,
      0.579937,
      0,
      0.305201,
      6.108661,
      0.792956,
      NULL,
      7,
      2,
      0.764454,
      6,
      1,
      NULL,
      1.766277,
      NULL,
      1,
      1.766793,
      1.472822,
      1.335635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.397500,
      1,
      0.708795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074777,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      1.660294,
      1,
      6.212182,
      1,
      NULL,
      NULL,
      1.431798,
      4.180082,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.631889,
      NULL,
      3,
      0,
      3,
      0,
      1,
      3.523294,
      1,
      1.997260,
      1,
      1.807736,
      1.821775,
      0,
      1.633978,
      0,
      0.842725,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '40104',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      '2240',
      '',
      '',
      4,
      0.430395,
      NULL,
      NULL,
      2.509342,
      5.553640,
      3,
      3,
      3.962616);
commit;
end;
/


