set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      '41223444',
      26.268794,
      65.277975,
      '2211240',
      45,
      0,
      2.465218,
      3,
      NULL,
      NULL,
      ' 2- 5-1997',
      34.941788,
      27.650679,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.844309,
      NULL,
      0.680301,
      0,
      0,
      1,
      0.149975,
      4.077482,
      1.725270,
      1.887312,
      0,
      7,
      0.617141,
      3,
      1,
      NULL,
      2,
      0.605409,
      1,
      7,
      0,
      0,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.545792,
      NULL,
      0,
      3,
      1.490821,
      0.762033,
      3.998595,
      3.142328,
      2,
      1.120813,
      3.952357,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.056661,
      1,
      NULL,
      2.248185,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.740048,
      1.662008,
      0.805617,
      1,
      1,
      0.002726,
      0.145751,
      1,
      0.574825,
      0.158347,
      NULL,
      NULL,
      1.225724,
      1.439601,
      NULL,
      NULL,
      1.415635,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.839945,
      1,
      0,
      1.508733,
      1,
      1.123785,
      1.526584,
      0.971087,
      1,
      0,
      0,
      0,
      1,
      2,
      7,
      6,
      4,
      NULL,
      1.175600,
      NULL,
      1,
      0,
      1,
      1.083303,
      2,
      0.917966,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661162,
      0.881810,
      0,
      0,
      0,
      1.415396,
      1.403522,
      0.398315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      NULL,
      3,
      1.074275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239655,
      0,
      1.738083,
      4,
      5,
      1,
      3.289752,
      1.034823,
      NULL,
      NULL,
      3.461796,
      3.802382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155852,
      0.749639,
      1,
      3.214928,
      NULL,
      1.952918,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.821014,
      0,
      0.689256,
      0,
      1,
      0,
      1.215707,
      0.883317,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3,
      2,
      1,
      0.447571,
      1,
      3,
      1.431768,
      0,
      1.764080);
commit;
end;
/


