set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      NULL,
      37.396086,
      16.588456,
      '0321313',
      56,
      5,
      1,
      NULL,
      '324344',
      3.608616,
      NULL,
      12,
      24.056622,
      1.142312,
      NULL,
      0,
      1.594404,
      1.597592,
      1,
      1.439375,
      1,
      0.225800,
      NULL,
      3,
      1.727056,
      NULL,
      1.453409,
      1,
      2.570577,
      6,
      NULL,
      NULL,
      2.803729,
      6.183748,
      0,
      0,
      NULL,
      0,
      1,
      1.062687,
      1.812075,
      0.357816,
      1.172301,
      NULL,
      NULL,
      1.917333,
      NULL,
      NULL,
      2.705183,
      11.921236,
      4,
      0.444184,
      NULL,
      1,
      NULL,
      1.964483,
      1,
      0,
      0,
      3.573288,
      1,
      2,
      1,
      0.072582,
      1,
      3.167838,
      1,
      NULL,
      0,
      2.788529,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.405065,
      0.491881,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.687621,
      NULL,
      1.811475,
      0,
      NULL,
      1.339345,
      1.428211,
      0.308898,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.959898,
      0,
      7.761062,
      2,
      2,
      NULL,
      0,
      7.493481,
      3.399577,
      5,
      1,
      1.784528,
      1,
      2.002739,
      1,
      0,
      2.707901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0.729510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3.513285,
      5.527998,
      1,
      3,
      NULL,
      1,
      3,
      5,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5.609058,
      1,
      2.927121,
      1,
      3,
      0.994238,
      NULL,
      NULL,
      0.116014,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.228912,
      1.165001,
      1,
      0,
      0.900944,
      0,
      1,
      0.324439,
      0.206239,
      1,
      1.726954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '22400',
      '',
      '',
      0,
      '',
      NULL,
      '',
      3,
      '1110',
      NULL,
      '',
      5,
      NULL,
      2,
      0,
      1,
      2,
      1.944389,
      1.608204,
      0);
commit;
end;
/


