set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '44300144',
      55.010142,
      NULL,
      '4330443',
      125,
      5,
      3.476689,
      3,
      '044201',
      2.488884,
      ' 3-16-1999',
      NULL,
      22,
      0,
      NULL,
      0,
      0.021747,
      1.659289,
      0.400284,
      1.460233,
      0.876442,
      0.534001,
      0.035533,
      NULL,
      0,
      1,
      1.208157,
      0.840589,
      0,
      4,
      0.654045,
      5.156588,
      1.696358,
      NULL,
      1.041207,
      3,
      1,
      0.685614,
      1,
      3.866818,
      2.264346,
      1.356509,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.142461,
      6,
      5,
      1.907176,
      1,
      0,
      2,
      NULL,
      2.488507,
      2,
      2.033575,
      2,
      1.045677,
      0,
      0,
      2,
      NULL,
      1,
      3.270890,
      2,
      0.258908,
      4,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.007460,
      0,
      0,
      0.600146,
      1,
      1,
      0.340331,
      1,
      0.915938,
      1,
      1.963862,
      0,
      0,
      0,
      1,
      0.395963,
      NULL,
      0.980131,
      NULL,
      NULL,
      0.014822,
      1.410812,
      0.867387,
      NULL,
      0.246352,
      0.206752,
      NULL,
      3.223887,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.172198,
      1,
      1.831231,
      0.230060,
      NULL,
      3,
      NULL,
      2,
      5,
      2.763510,
      NULL,
      2,
      0.086175,
      0.640749,
      1.739996,
      NULL,
      NULL,
      NULL,
      6,
      1.973491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151613,
      1.851986,
      NULL,
      1,
      0.887784,
      1.500758,
      0.581697,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295332,
      NULL,
      NULL,
      NULL,
      NULL,
      2.071808,
      1,
      1,
      NULL,
      0,
      2.739250,
      1.471059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.743127,
      1,
      0.023475,
      0,
      0.478373,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.859425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564669,
      1.615703,
      3.130860,
      1,
      NULL,
      0.401314,
      NULL,
      3.423583,
      0.276035,
      1.242949,
      NULL,
      0,
      0.941090,
      1,
      1,
      1.022224,
      1.906128,
      0.115413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '10300',
      '',
      '',
      1.019688,
      '',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      3.786356,
      NULL,
      1,
      5.190544,
      5.022235,
      NULL,
      NULL,
      2,
      NULL);
commit;
end;
/


