set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '34430132',
      33.105522,
      66.743769,
      NULL,
      80.089476,
      1,
      3.999837,
      0,
      '001210',
      1,
      ' 4-23-1994',
      32,
      NULL,
      1.442528,
      NULL,
      NULL,
      0,
      3.236013,
      NULL,
      0.016779,
      1,
      NULL,
      1.617618,
      1,
      NULL,
      0.215656,
      NULL,
      1,
      3,
      5,
      NULL,
      3,
      0.774318,
      0.204676,
      5.079493,
      0.570385,
      0.298458,
      1.190796,
      1,
      4,
      0,
      2.729936,
      1.366695,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.193817,
      3,
      1.380628,
      1,
      1.654607,
      NULL,
      0,
      1,
      2.665232,
      3,
      0.689965,
      3,
      2.433140,
      NULL,
      NULL,
      0.259553,
      0,
      1.045564,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.969238,
      4,
      NULL,
      NULL,
      NULL,
      1,
      0.369492,
      1,
      0.592358,
      0.132228,
      NULL,
      0,
      0.293621,
      1,
      NULL,
      0.163801,
      1,
      1,
      NULL,
      1.974848,
      0,
      0,
      0,
      1.316027,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.523595,
      NULL,
      0,
      0,
      1.836839,
      NULL,
      4,
      1,
      NULL,
      2.845961,
      9.355911,
      2,
      1,
      NULL,
      1,
      3,
      1.977709,
      NULL,
      0.478959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544105,
      0.334468,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.334140,
      1.494390,
      0.075844,
      1.980192,
      1.949190,
      0.155526,
      2.558638,
      2.665114,
      3,
      1.427291,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.699911,
      1.185010,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.305996,
      0.643178,
      0.654486,
      0,
      0,
      NULL,
      1,
      0.283972,
      0.489711,
      NULL,
      1,
      1,
      1.833303,
      0.550017,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.200711,
      '12314',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '4113',
      '',
      '',
      NULL,
      2.881057,
      2,
      1,
      3,
      3,
      1.099196,
      NULL,
      NULL);
commit;
end;
/


