set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4021',
      '40143401',
      NULL,
      NULL,
      NULL,
      47,
      6,
      3,
      3,
      '131030',
      4.172145,
      ' 0- 5-1991',
      24.670730,
      33,
      0.131895,
      NULL,
      NULL,
      1,
      0.760138,
      NULL,
      1,
      1.009930,
      0.969295,
      0.091473,
      1,
      1,
      4,
      0,
      0,
      NULL,
      NULL,
      1.481816,
      0,
      1,
      0,
      6,
      1,
      1,
      6,
      0,
      4.204615,
      3.240947,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.128211,
      NULL,
      0,
      NULL,
      1.158944,
      NULL,
      2,
      1,
      3,
      0.234491,
      2.683204,
      1.454771,
      2,
      2.410933,
      1,
      1,
      0,
      1,
      NULL,
      0.125213,
      NULL,
      2,
      8,
      0,
      NULL,
      1,
      0.603093,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.019807,
      0.889090,
      3,
      0.645252,
      3,
      2.731626,
      0,
      0,
      0,
      5,
      5.772039,
      4,
      0.773444,
      1,
      0.131290,
      0.106751,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.669463,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.392842,
      0.152756,
      0.779854,
      4.029864,
      4,
      0,
      3.421143,
      6.047052,
      1.328481,
      6,
      5,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957810,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0.528831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.787756,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      NULL,
      0.920727,
      NULL,
      1.937172,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.191666,
      0.154867,
      2.072020,
      1,
      2,
      1.809389,
      NULL,
      NULL,
      NULL,
      1.559184,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962194,
      1,
      0,
      1.232731,
      1,
      NULL,
      1.869646,
      1,
      NULL,
      3.309072,
      1,
      1.038053,
      0.406794,
      0.949695,
      1,
      0,
      0.477033,
      1,
      0.911878,
      0.883262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '12014',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      2.277740,
      '3423',
      '',
      NULL,
      1.516283,
      0.438506,
      2.044918,
      NULL,
      1.240108,
      3,
      3.303319,
      0.571103,
      2.518339);
commit;
end;
/


