set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01024323',
      64,
      68,
      '0120432',
      38,
      6,
      2,
      0,
      '200011',
      3,
      ' 3-21-1977',
      NULL,
      32,
      NULL,
      NULL,
      1.796699,
      NULL,
      2,
      1.081378,
      1.885870,
      0,
      0.786602,
      1,
      0.383054,
      NULL,
      4,
      0.868720,
      1,
      0,
      2,
      1.288114,
      NULL,
      0.918296,
      NULL,
      1.805823,
      1,
      1,
      5,
      0,
      1.154925,
      NULL,
      1.166326,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.624736,
      1.965201,
      NULL,
      1.613880,
      0.780076,
      1,
      2.962107,
      0.731649,
      0,
      1,
      3,
      0.506275,
      0,
      1.611220,
      3,
      2,
      1,
      1,
      0,
      NULL,
      1.720962,
      1,
      3,
      1,
      0,
      2.588167,
      1.766946,
      NULL,
      NULL,
      1.977982,
      NULL,
      NULL,
      0,
      1.322947,
      0.950384,
      0,
      NULL,
      NULL,
      NULL,
      1.232215,
      1.093783,
      0,
      0,
      0,
      0.632834,
      1,
      1.623922,
      1,
      1,
      0.840813,
      0.565451,
      NULL,
      1.055904,
      NULL,
      1,
      1.909943,
      0.037540,
      1.884210,
      1.434629,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958031,
      0,
      0,
      NULL,
      1,
      6,
      1,
      3.257193,
      4.930981,
      6,
      0.477646,
      NULL,
      NULL,
      0,
      1,
      0,
      0.952229,
      0.280422,
      0.970483,
      2.894341,
      1.492551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.822273,
      1.411138,
      0,
      1.203924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9,
      0.049445,
      1,
      NULL,
      2.383734,
      2.066015,
      NULL,
      1,
      3,
      7.545145,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.626005,
      5,
      3,
      0.038735,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.540807,
      8.201715,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.238484,
      1.195499,
      2.847906,
      NULL,
      0.979358,
      2,
      1,
      NULL,
      1.297672,
      0.365403,
      1,
      0,
      NULL,
      0,
      NULL,
      0.779307,
      0,
      1,
      0.718245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1.185971,
      '1031',
      '',
      '',
      3.642818,
      4.909475,
      3,
      NULL,
      1,
      0,
      2,
      2.009788,
      0);
commit;
end;
/


