set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4020',
      '14132310',
      74.087378,
      48,
      '4101310',
      115,
      0,
      2,
      3,
      '123221',
      3.978062,
      ' 8- 2-1979',
      40,
      62,
      0.227712,
      NULL,
      0,
      1,
      3.600661,
      NULL,
      0.283652,
      NULL,
      0,
      0,
      NULL,
      1.490275,
      4.206422,
      1.279394,
      1.669363,
      NULL,
      NULL,
      3,
      0.944558,
      1,
      1,
      0,
      0,
      0,
      4,
      0,
      5,
      2,
      3.163808,
      NULL,
      NULL,
      NULL,
      0.549295,
      NULL,
      NULL,
      2,
      1.037005,
      1.948304,
      1,
      1,
      NULL,
      3,
      1.016481,
      0.939820,
      NULL,
      3,
      1.098502,
      1,
      0,
      NULL,
      2.887757,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      7.501452,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.876776,
      NULL,
      NULL,
      0.389348,
      NULL,
      2.346136,
      0,
      4,
      1,
      1.944881,
      NULL,
      NULL,
      NULL,
      4.565265,
      3.128753,
      1.833281,
      3,
      0,
      1,
      0,
      1.286979,
      1,
      NULL,
      0.633522,
      1,
      NULL,
      0,
      1.646447,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051943,
      0.249431,
      0.945890,
      NULL,
      1.965721,
      3.590012,
      4,
      4,
      5,
      NULL,
      1,
      NULL,
      6,
      1.843226,
      NULL,
      1.843408,
      2,
      1.448064,
      1,
      0.124680,
      0.695007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372403,
      0.809746,
      1,
      0,
      1,
      0.593556,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.624322,
      1,
      2,
      1.539406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.854887,
      NULL,
      NULL,
      2,
      0.580636,
      1.024411,
      1,
      0,
      NULL,
      0,
      1,
      2,
      2.143380,
      0,
      NULL,
      NULL,
      NULL,
      1.614275,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.269954,
      3,
      NULL,
      1.702319,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0.496347,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '33240',
      NULL,
      NULL,
      0.219863,
      '',
      '',
      '',
      2,
      '3401',
      '',
      '',
      4.881793,
      3.479465,
      2.027140,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.013605);
commit;
end;
/


