set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '3411014',
      7.572440,
      2,
      2.521224,
      1,
      '222322',
      2.071477,
      ' 2-13-1977',
      9,
      NULL,
      0.650691,
      NULL,
      1,
      0.695970,
      2,
      0.438647,
      1,
      1,
      NULL,
      1,
      1.215628,
      1,
      1,
      0.907937,
      NULL,
      1,
      NULL,
      0,
      0.942352,
      1.070871,
      NULL,
      9,
      1.948540,
      0.280580,
      NULL,
      NULL,
      2.195152,
      1,
      1.196490,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.393277,
      1.788595,
      NULL,
      1,
      NULL,
      0.329519,
      NULL,
      0.586530,
      1.898909,
      0,
      0,
      1.562479,
      0.451336,
      0,
      1.648602,
      NULL,
      1.930259,
      1,
      1.439128,
      NULL,
      1.596577,
      3.148957,
      NULL,
      NULL,
      NULL,
      1.372767,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.113085,
      1,
      NULL,
      0.051577,
      NULL,
      NULL,
      0,
      0.985399,
      NULL,
      0,
      1.731748,
      1,
      0,
      1.113674,
      1,
      0,
      1.340508,
      0.700837,
      NULL,
      0.863164,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.807521,
      0,
      3,
      0,
      NULL,
      0,
      1,
      1.957714,
      1.034190,
      NULL,
      NULL,
      NULL,
      4.649665,
      1,
      1.808968,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045074,
      0,
      1,
      1.135280,
      0.328920,
      0.074965,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942341,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.736666,
      1,
      4.153408,
      7.178407,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.799862,
      1.889745,
      0.014330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213139,
      1.335165,
      NULL,
      2.153801,
      2,
      0,
      0.107218,
      1,
      3,
      1.701839,
      1,
      0.635954,
      NULL,
      0,
      1,
      1.268117,
      1,
      0,
      0.040739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11203',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


