set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '1343200',
      12.309912,
      0,
      0,
      2,
      NULL,
      0,
      ' 6- 0-1974',
      NULL,
      NULL,
      0.805280,
      NULL,
      2,
      0.547462,
      1,
      1,
      1.412207,
      1.456998,
      0,
      0,
      0.701998,
      0.389523,
      0.117152,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1.955456,
      NULL,
      1.274614,
      0.502758,
      7,
      1,
      2.429745,
      0,
      2.228956,
      1.558102,
      NULL,
      NULL,
      1.247400,
      NULL,
      NULL,
      9.117214,
      1.267065,
      1.602337,
      0.053296,
      NULL,
      NULL,
      NULL,
      NULL,
      2.177160,
      0,
      0,
      NULL,
      0,
      1.778402,
      NULL,
      1.577352,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.001515,
      NULL,
      NULL,
      1,
      0.494308,
      1.495665,
      NULL,
      NULL,
      1,
      1.803576,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0.819233,
      0,
      1.380795,
      0,
      0,
      0.408248,
      NULL,
      0.425215,
      NULL,
      0,
      1.774744,
      1,
      1,
      0,
      NULL,
      2.047138,
      1.520793,
      3.963954,
      0.989433,
      NULL,
      0,
      2,
      0.460622,
      NULL,
      2.244743,
      4.539807,
      2.104400,
      5,
      NULL,
      5.225452,
      4,
      2.622005,
      3,
      NULL,
      1.969862,
      1.874860,
      NULL,
      1,
      8,
      0.755737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687689,
      0.131746,
      1,
      0,
      NULL,
      0.549993,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.624220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      7,
      7,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.346193,
      3.422583,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574458,
      0.610649,
      1.259720,
      1,
      NULL,
      1.445965,
      NULL,
      0,
      0.469382,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0.656237,
      1,
      NULL,
      0.506814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779244,
      '30140',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.642737,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


