set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '4041040',
      10,
      4,
      1.869282,
      NULL,
      '042143',
      2.065537,
      '11- 8-1986',
      12.465884,
      NULL,
      0.631158,
      NULL,
      5,
      1.091893,
      3.711561,
      0.405665,
      1,
      1,
      0,
      0.638666,
      1.430636,
      NULL,
      1,
      0.767166,
      1.036045,
      0,
      0.100051,
      0.492022,
      NULL,
      1.549828,
      0.347986,
      0.489677,
      1,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.596983,
      NULL,
      NULL,
      2.294303,
      0.072978,
      0.416275,
      NULL,
      0.000087,
      0.249456,
      0.541067,
      3.589619,
      NULL,
      0.500716,
      1.768342,
      1,
      0,
      1,
      1.262711,
      1.715333,
      0.691270,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      2,
      0.072575,
      1.077842,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.767025,
      1,
      1.444075,
      0.149611,
      0,
      1.902296,
      0.580613,
      1.276836,
      1,
      0,
      0,
      1,
      0,
      1.118842,
      NULL,
      NULL,
      1.923524,
      0.718543,
      1,
      NULL,
      0.307500,
      3,
      1.293760,
      0,
      1.252664,
      1.436295,
      1,
      NULL,
      3,
      0.117623,
      2,
      0.771205,
      NULL,
      0.401920,
      3.247093,
      1.497290,
      0,
      2.420050,
      1.128687,
      1,
      0.994803,
      1,
      4,
      4,
      7.697861,
      6,
      0,
      1,
      NULL,
      0,
      0.926726,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0.722955,
      0.387440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517425,
      1,
      NULL,
      NULL,
      NULL,
      6,
      1,
      2,
      0,
      1.725182,
      NULL,
      0.252353,
      NULL,
      NULL,
      NULL,
      0.444484,
      NULL,
      0.779689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.126914,
      1.414183,
      1,
      NULL,
      0.940167,
      0.254284,
      0.056306,
      NULL,
      0,
      1.621260,
      1,
      0,
      0.542026,
      0.786657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.180367,
      '24201',
      '',
      '',
      0.609357,
      '',
      '',
      NULL,
      1.423803,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


