set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '2333334',
      18.874354,
      1,
      3,
      NULL,
      '102204',
      2,
      ' 7-29-1988',
      3,
      NULL,
      0.158686,
      NULL,
      1.576008,
      3.965626,
      1.937214,
      1,
      NULL,
      0,
      1.908984,
      1,
      0.130718,
      1,
      1,
      1,
      0.341913,
      0,
      1,
      NULL,
      0.222090,
      0,
      NULL,
      1.746943,
      0.178908,
      0,
      5,
      1,
      NULL,
      5,
      0.530510,
      1.945060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      0.264990,
      1.239024,
      NULL,
      1.523771,
      0.495093,
      0,
      1.650374,
      0,
      1.199634,
      0,
      NULL,
      NULL,
      0.301261,
      0,
      0.469706,
      0,
      0,
      0,
      5,
      1,
      0,
      NULL,
      1.176550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.560413,
      1.716735,
      1,
      0.439559,
      NULL,
      0.482868,
      6,
      0.035408,
      1.030742,
      0.388922,
      1.764775,
      1,
      1.168323,
      0.778414,
      NULL,
      0.574762,
      0,
      1.320179,
      0,
      NULL,
      1.375900,
      0,
      3,
      NULL,
      0,
      1.525703,
      1,
      0,
      0,
      NULL,
      NULL,
      4,
      1.649822,
      0,
      0.816719,
      4.470718,
      NULL,
      5,
      NULL,
      3,
      6,
      2,
      1.679425,
      2,
      6,
      3.178618,
      1,
      NULL,
      3.178332,
      0,
      1,
      NULL,
      0.368571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442829,
      1,
      NULL,
      NULL,
      1,
      0,
      1.761446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.523799,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.789062,
      1,
      1.380452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000241,
      NULL,
      0,
      NULL,
      0.631928,
      1.834712,
      NULL,
      0,
      0,
      2.934167,
      1,
      1,
      NULL,
      0,
      NULL,
      0.051197,
      0.626515,
      1.754149,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      0.445570,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


