set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '3000110',
      22,
      0,
      NULL,
      3,
      '240333',
      NULL,
      ' 6-22-1985',
      25.520297,
      NULL,
      1,
      NULL,
      1.927972,
      3,
      0,
      NULL,
      0.027304,
      0.674752,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.761545,
      1.828917,
      0.808133,
      1.741721,
      1,
      1.489151,
      1.244398,
      0.444729,
      1,
      0,
      NULL,
      NULL,
      1.757172,
      3,
      3.810001,
      1.613578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10,
      1,
      0,
      3.558094,
      NULL,
      0.055572,
      1.173379,
      3,
      1,
      0,
      3.256359,
      0,
      1.154321,
      1,
      0.391600,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      1.464664,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.750973,
      1.532530,
      0,
      0.665130,
      3,
      1,
      6.667447,
      1,
      1,
      1.606337,
      2,
      NULL,
      1.495243,
      4.560956,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.616776,
      1.377615,
      NULL,
      4,
      1.965381,
      1,
      0.570206,
      2.017705,
      3.475062,
      0.428065,
      0.063542,
      4,
      7.692955,
      1.452359,
      7,
      5.037512,
      3.429182,
      3,
      1,
      2,
      5.640154,
      1,
      1,
      0,
      3,
      3,
      0.399016,
      1,
      0.885645,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0.102190,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.149783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0.402709,
      NULL,
      0.897663,
      NULL,
      NULL,
      NULL,
      0.059462,
      0.711108,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.988593,
      NULL,
      1.148276,
      0.858753,
      3.980455,
      0,
      2.977135,
      1.546867,
      NULL,
      NULL,
      0.978331,
      1,
      0,
      0.616136,
      NULL,
      0.494767,
      1.085818,
      0.677086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.483739,
      '24240',
      '',
      '',
      1,
      '',
      '',
      '',
      1.873204,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


