set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '3411421',
      10.721479,
      0,
      2.409872,
      1,
      '412211',
      1.371796,
      ' 5- 4-1993',
      NULL,
      NULL,
      0,
      NULL,
      0.335438,
      1.863718,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.995740,
      0,
      1.066821,
      1,
      1,
      0,
      4.200880,
      NULL,
      1.588024,
      0.240130,
      0,
      NULL,
      0,
      NULL,
      1.490268,
      NULL,
      NULL,
      1.008906,
      NULL,
      NULL,
      0.374679,
      0.465078,
      1.912122,
      3.590358,
      0.958530,
      0.165049,
      NULL,
      2,
      0,
      1.220688,
      1.986501,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680343,
      1,
      0.951735,
      NULL,
      0,
      0,
      1.119541,
      1,
      NULL,
      NULL,
      0.022646,
      NULL,
      NULL,
      0,
      0.397103,
      NULL,
      0.458777,
      0,
      2,
      0.046038,
      0,
      0,
      2.602385,
      5.767128,
      0,
      NULL,
      5,
      0.747317,
      1,
      1.274651,
      1,
      0,
      NULL,
      1.954138,
      NULL,
      1.305258,
      NULL,
      NULL,
      0,
      NULL,
      1.915759,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.633056,
      1,
      NULL,
      NULL,
      6.494897,
      NULL,
      5.220324,
      0,
      3.170866,
      3.448330,
      5.931791,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015980,
      2,
      1,
      NULL,
      1,
      0.158125,
      1,
      0.455083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.998882,
      0.499939,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.411686,
      1,
      1.329873,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.789417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.258379,
      1.811817,
      0,
      1,
      2,
      0.134425,
      0.416819,
      0,
      NULL,
      0,
      0.778824,
      1,
      1,
      1.465153,
      1,
      0.909068,
      1.515571,
      1.634251,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.323769,
      '10142',
      '',
      '',
      0.644944,
      '',
      '',
      '',
      0.937330,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


