set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '023',
      '21',
      2.912544,
      14,
      NULL,
      17.898229,
      3,
      3,
      2,
      '241342',
      3,
      ' 5- 2-1993',
      2,
      52,
      NULL,
      NULL,
      0.521058,
      0.679513,
      NULL,
      1.529668,
      0,
      0,
      1.752032,
      0.721653,
      1,
      0.767889,
      2,
      0.996072,
      0,
      0.070201,
      1.840916,
      0.595590,
      5.283580,
      1,
      0,
      0.324089,
      NULL,
      0.379795,
      0.200661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.425883,
      1.404357,
      0.774080,
      0.327393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912850,
      0,
      1,
      4.689013,
      NULL,
      1,
      2,
      NULL,
      1.234092,
      2,
      1.245930,
      1.614636,
      1.064693,
      2.295116,
      1.445792,
      NULL,
      0,
      1.724714,
      1.748743,
      NULL,
      1,
      3,
      1,
      1.896793,
      0.360064,
      0,
      NULL,
      1.969597,
      5,
      0.970334,
      0.918124,
      8,
      NULL,
      1.531868,
      0.372643,
      0,
      0.460571,
      0.830661,
      2,
      4.134702,
      1.287734,
      1,
      2,
      3,
      1,
      3.377753,
      1,
      2.117347,
      1,
      NULL,
      NULL,
      NULL,
      0.904718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.351125,
      NULL,
      1,
      1.392366,
      0,
      0.553154,
      1.202689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259762,
      NULL,
      3,
      NULL,
      2,
      1.998770,
      NULL,
      1.660579,
      NULL,
      1,
      0,
      4,
      1,
      NULL,
      2,
      0,
      0.823760,
      0,
      0,
      0.118968,
      3,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      3.892533,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085083,
      NULL,
      2,
      0.549729,
      1.591024,
      1.776214,
      1.261080,
      0.777735,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1.818469,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '2310',
      NULL,
      NULL,
      3,
      NULL,
      '',
      '',
      1.435297,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


