set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '210',
      NULL,
      25.731078,
      11.172861,
      '1222120',
      5.823574,
      2,
      0.638123,
      NULL,
      '334414',
      2.274261,
      ' 4- 3-1986',
      48.320887,
      8,
      1,
      NULL,
      1.482526,
      3.276108,
      0.576888,
      NULL,
      1.509010,
      1.133912,
      0,
      0.246020,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.902403,
      3.863354,
      NULL,
      1,
      0,
      1.526214,
      0,
      1.992276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.832393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.916752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0.323657,
      3,
      1,
      1,
      1,
      0.399967,
      3.750514,
      1.221047,
      1.515015,
      0.219703,
      0.583528,
      NULL,
      1.004208,
      0.514082,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.851578,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1.843372,
      NULL,
      1.000791,
      3,
      4,
      2,
      1.688803,
      5.341206,
      1.622238,
      2.782648,
      6,
      NULL,
      6,
      NULL,
      6,
      3.804852,
      1.382240,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.727359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440978,
      1,
      1,
      1,
      0.259521,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      6,
      3.882333,
      0.786468,
      NULL,
      3,
      2.255052,
      1.672127,
      1,
      3,
      5.868948,
      0.709643,
      0.965806,
      NULL,
      NULL,
      NULL,
      5.190026,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      10,
      2,
      5,
      1,
      6.750218,
      1,
      2,
      1.944789,
      1,
      2,
      3.319164,
      2.727711,
      NULL,
      1,
      0.190279,
      0.481778,
      NULL,
      NULL,
      NULL,
      0.993140,
      1.239414,
      0.925033,
      0,
      1.976483,
      1,
      1.699972,
      0.156257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '3431',
      '03214',
      1,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      4.702675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


