set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '14',
      33,
      19.240552,
      '4110343',
      0,
      NULL,
      0,
      0,
      '024100',
      5,
      ' 4-28-1999',
      44,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.682221,
      0,
      NULL,
      1.544933,
      NULL,
      1.070795,
      1,
      1,
      2.865413,
      0.136009,
      NULL,
      1,
      1.579052,
      1.185915,
      6,
      1.200479,
      0,
      1.581627,
      1,
      1.508028,
      3.472751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.354571,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.512013,
      4.973029,
      1,
      0,
      NULL,
      NULL,
      1.317565,
      1.699780,
      0,
      0.191603,
      NULL,
      0.191590,
      1.062674,
      1.628668,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.601439,
      0,
      0.780091,
      0,
      3.771233,
      NULL,
      5.602780,
      1.127114,
      1,
      3.681357,
      1.490814,
      5.621256,
      4.979423,
      1,
      NULL,
      NULL,
      4,
      4.270531,
      NULL,
      NULL,
      NULL,
      NULL,
      6.810544,
      1,
      6.873442,
      0.613219,
      NULL,
      NULL,
      NULL,
      3,
      0.726684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738614,
      1.515774,
      0,
      1,
      1.910510,
      1.063406,
      NULL,
      1.419245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.297180,
      NULL,
      8.754583,
      0.527040,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.529081,
      0.748058,
      NULL,
      NULL,
      NULL,
      0.280305,
      0.243945,
      2.093522,
      0,
      7,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      6,
      1.867478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.851118,
      NULL,
      2.106158,
      2.540944,
      0,
      0.623848,
      NULL,
      1.447599,
      0.827801,
      NULL,
      0.997702,
      0,
      1,
      1,
      0.599713,
      1.272088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '1423',
      NULL,
      '30301',
      2.562301,
      '2001',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      5.405678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


