set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '444',
      '21',
      19,
      27.965069,
      '4131434',
      9,
      1,
      NULL,
      2,
      '410133',
      5,
      '10-26-1988',
      51.414002,
      26,
      0,
      NULL,
      1,
      2.383351,
      1,
      NULL,
      NULL,
      1.354556,
      0.686144,
      NULL,
      NULL,
      1,
      1.909316,
      NULL,
      1,
      1,
      0.218723,
      1.992263,
      4.696324,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996901,
      0,
      0.368234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.009524,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      1.712255,
      0,
      0,
      0.905203,
      1,
      0.366608,
      1,
      NULL,
      1.293084,
      NULL,
      1.483128,
      4,
      5,
      NULL,
      0,
      NULL,
      0.882480,
      0.062966,
      5.997636,
      0,
      1,
      1,
      1,
      4,
      4.755118,
      5.696373,
      1.437559,
      0.665766,
      0.497180,
      5,
      6,
      3.790696,
      0,
      1.541191,
      NULL,
      1,
      3.242261,
      4.341626,
      1.809349,
      NULL,
      NULL,
      1.222088,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194579,
      NULL,
      1,
      1,
      1.785665,
      1.131952,
      1.033489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.595658,
      NULL,
      4.017627,
      3.377858,
      2.335218,
      4.680473,
      NULL,
      0,
      1.195883,
      NULL,
      0.638474,
      0,
      0,
      2.096102,
      NULL,
      3,
      0,
      0,
      0,
      2,
      1.776699,
      NULL,
      2,
      0.351572,
      NULL,
      NULL,
      NULL,
      2.151911,
      3.235899,
      1.236841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.631853,
      3.055561,
      1.363831,
      NULL,
      3,
      2.095529,
      1,
      0.557205,
      1,
      NULL,
      0,
      1.982185,
      NULL,
      1.372842,
      0,
      0,
      0,
      0.927490,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      '1110',
      '0244',
      '20334',
      1,
      '3322',
      '',
      '',
      1.776890,
      '',
      '',
      '',
      0,
      5.038485,
      1.803301,
      0,
      NULL,
      2,
      1,
      NULL,
      3.897471);
commit;
end;
/


