set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '10331023',
      29,
      39.992218,
      NULL,
      20,
      4,
      2.889946,
      3,
      '022023',
      4.532975,
      NULL,
      NULL,
      18,
      1,
      NULL,
      1.479239,
      3,
      0,
      0.307844,
      0,
      1.638341,
      0.099029,
      0,
      NULL,
      1.882831,
      3,
      0.298614,
      0.838337,
      0,
      NULL,
      1,
      1,
      0.555091,
      NULL,
      NULL,
      0,
      0.035269,
      2.776796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315528,
      1.715063,
      1.714671,
      1.763025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577044,
      0,
      1.924459,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205769,
      0.434930,
      NULL,
      0.653516,
      5,
      NULL,
      2.083096,
      1,
      NULL,
      1,
      NULL,
      0.218687,
      1.174228,
      3,
      NULL,
      0.928481,
      0,
      0,
      1,
      NULL,
      0.103884,
      4,
      2,
      NULL,
      0,
      1,
      5.369481,
      0.304860,
      2.787426,
      0.043700,
      0.219819,
      1.913956,
      0.263823,
      4,
      1.462419,
      NULL,
      0,
      NULL,
      0.258325,
      4.042319,
      1,
      0.187624,
      NULL,
      3,
      2.081871,
      3,
      NULL,
      2.202919,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470245,
      1.004932,
      0,
      0,
      0,
      0.199143,
      0.546402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753790,
      NULL,
      5.646314,
      0,
      2.116859,
      1,
      1,
      0,
      0,
      NULL,
      1.895545,
      2,
      0,
      2.029956,
      0.866633,
      3.516437,
      1,
      1,
      1.571273,
      2,
      3,
      4,
      NULL,
      0.843273,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.207317,
      2,
      1,
      NULL,
      NULL,
      0.781917,
      2,
      NULL,
      1,
      0.912565,
      1.703199,
      0.206821,
      0,
      0.205699,
      1.469679,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      '4010',
      '2400',
      '10021',
      0,
      '0323',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      3.665741,
      3.231540,
      4.819784,
      NULL,
      2.278428,
      1,
      0.547539,
      0.050812);
commit;
end;
/


