set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      33.409476,
      15.249668,
      '3201013',
      3.662393,
      3,
      NULL,
      1,
      '122023',
      3,
      ' 8-24-1983',
      39.002186,
      25,
      0,
      NULL,
      0.359177,
      1.520550,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1.198296,
      1.783241,
      0.487503,
      0.514078,
      1.086374,
      7,
      1,
      0,
      1.327174,
      1.591427,
      NULL,
      1.482324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158282,
      1.120340,
      0.049624,
      1.624804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659854,
      0,
      0.842121,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.938610,
      0,
      2.822874,
      1,
      0.572961,
      1.398379,
      1,
      1,
      0.926118,
      0.848717,
      0.307975,
      0,
      0.148663,
      1,
      0,
      0.811859,
      NULL,
      NULL,
      0.809741,
      0,
      1.948758,
      1.476797,
      NULL,
      NULL,
      5.529062,
      1.423589,
      5,
      1,
      NULL,
      4,
      NULL,
      NULL,
      5,
      NULL,
      0,
      7,
      4,
      5.512921,
      4.666724,
      9.616926,
      0.009278,
      6,
      3,
      5,
      NULL,
      1,
      2,
      1.209981,
      0,
      2.152539,
      0.053078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744745,
      0.408755,
      1,
      1,
      1,
      0,
      0,
      1.654056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.985465,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.760553,
      1.079686,
      1.501227,
      0.711528,
      0.379879,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.250974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.624582,
      3,
      0,
      2.954174,
      0,
      2,
      3.642979,
      1.801731,
      0,
      1,
      0.865001,
      1,
      NULL,
      1.732973,
      1.672943,
      1.635644,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.096853,
      '2441',
      '0430',
      '10014',
      0.986832,
      '1122',
      '',
      '',
      1,
      '',
      '',
      '',
      1.054237,
      NULL,
      NULL,
      1.843329,
      1,
      2.894091,
      3,
      0,
      0);
commit;
end;
/


