set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      '32403344',
      NULL,
      25.855058,
      '1122440',
      100.500456,
      NULL,
      2,
      NULL,
      '222024',
      4.084142,
      NULL,
      7.041336,
      NULL,
      1.541323,
      NULL,
      0,
      NULL,
      0.519488,
      NULL,
      1.664213,
      NULL,
      0,
      0,
      0.244339,
      0,
      1.444353,
      NULL,
      NULL,
      1,
      1.027389,
      0,
      2,
      0,
      0.333071,
      0,
      0.763787,
      1.339873,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.372076,
      NULL,
      0.265111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.096522,
      0.178223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702312,
      1.906493,
      NULL,
      4,
      3.377140,
      1,
      2.805791,
      1.744493,
      0.385273,
      0,
      1,
      1.135544,
      0,
      3,
      0.565707,
      1.629050,
      0,
      0,
      0,
      NULL,
      1.320882,
      2.562981,
      1.494933,
      NULL,
      0,
      2,
      4.458360,
      0.279454,
      1,
      2,
      3,
      9,
      0,
      1.933935,
      3.172060,
      2.306517,
      3.162431,
      7,
      6,
      6.927251,
      3.363409,
      NULL,
      4,
      9,
      9,
      5.224694,
      NULL,
      1.695125,
      0,
      NULL,
      NULL,
      2.499833,
      0.046446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.101501,
      2,
      1,
      1,
      1.773679,
      1.832248,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.852635,
      3.486602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.887378,
      0.137385,
      0.054602,
      0,
      3.270263,
      NULL,
      2,
      1,
      9.444497,
      1.972540,
      6,
      1,
      3,
      1.565905,
      NULL,
      NULL,
      0.054264,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763291,
      NULL,
      2,
      0.840302,
      1.764398,
      0.757387,
      NULL,
      3.547343,
      1.647873,
      1.441552,
      0.534833,
      0,
      1,
      NULL,
      0.602251,
      0.414718,
      0.339014,
      0.197184,
      1.752873,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '2132',
      '3011',
      '31231',
      2,
      '4434',
      NULL,
      '',
      0.439609,
      NULL,
      NULL,
      '',
      4.935900,
      5.347866,
      0,
      7,
      0.071174,
      NULL,
      1.829886,
      NULL,
      1.812175);
commit;
end;
/


