set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1420',
      '41214020',
      4,
      75.629614,
      NULL,
      48,
      3,
      0,
      3,
      NULL,
      2,
      ' 8-24-1977',
      20,
      48,
      1.831283,
      NULL,
      3,
      1.052468,
      1,
      0,
      1,
      2.381504,
      NULL,
      NULL,
      1,
      0.618998,
      3.564183,
      1.358651,
      1.716466,
      1.807524,
      0,
      1.319210,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1.440747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466457,
      0.233331,
      NULL,
      1.300585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.143381,
      1.568725,
      0.579189,
      0.885407,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      2.607240,
      0,
      3,
      3.668253,
      2.220647,
      1.923816,
      4.432998,
      4,
      0.319238,
      5.059151,
      0.505721,
      NULL,
      2,
      1,
      5,
      3,
      6.441598,
      4.147226,
      2,
      5,
      4.051105,
      7.788628,
      NULL,
      3,
      NULL,
      NULL,
      0.355039,
      NULL,
      NULL,
      1.445788,
      1.897515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752591,
      1,
      NULL,
      1,
      0.013645,
      0,
      NULL,
      0.310102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.178136,
      3.075732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628830,
      3,
      NULL,
      0.760148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.768404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336945,
      0.163517,
      1,
      0.451336,
      3,
      1.608487,
      2.459004,
      2.924013,
      0.307622,
      3,
      NULL,
      0,
      1.188354,
      0,
      0,
      1.414838,
      1,
      1,
      1.256444,
      0.323512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      '0020',
      '1021',
      '30330',
      2,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      3.419590,
      2,
      4.397884,
      NULL,
      6.203755,
      NULL,
      2.192974,
      1);
commit;
end;
/


