set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0031',
      '21232404',
      NULL,
      NULL,
      '2222220',
      101.213098,
      3,
      2,
      3,
      '410133',
      NULL,
      '10-19-1979',
      10.513927,
      11,
      1,
      NULL,
      2.330824,
      0,
      0,
      0.532901,
      1,
      1,
      1.499296,
      1,
      1,
      0,
      3.875611,
      0.572394,
      1.608217,
      1,
      NULL,
      1.715957,
      1,
      0,
      1,
      1.277323,
      0.833371,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.859964,
      0.345460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172153,
      1.510635,
      1,
      1.136024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158201,
      NULL,
      2.767416,
      NULL,
      0,
      0,
      1,
      0.323438,
      0,
      0.420769,
      NULL,
      NULL,
      1,
      1.329900,
      1.686751,
      NULL,
      1.719364,
      NULL,
      0,
      4,
      NULL,
      1.462089,
      NULL,
      2,
      NULL,
      0,
      4,
      NULL,
      1,
      9,
      3.735183,
      0.962664,
      5.219880,
      NULL,
      3.635536,
      0,
      5,
      2.295519,
      2.685650,
      7,
      NULL,
      2,
      0.029649,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      9,
      0.468003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.855149,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.360902,
      NULL,
      3,
      0.479631,
      3,
      2.182059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.389364,
      0.936601,
      2,
      2.664828,
      3,
      1,
      0.009980,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110335,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593777,
      NULL,
      NULL,
      1.280582,
      NULL,
      3.943981,
      1,
      1,
      0,
      NULL,
      0,
      0.742946,
      1.277358,
      1,
      1.759498,
      0.030237,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '3031',
      '0402',
      '30112',
      1,
      NULL,
      '',
      '',
      0.357400,
      '',
      '',
      '',
      7,
      NULL,
      3.694574,
      0.228650,
      NULL,
      NULL,
      3,
      1,
      2.734549);
commit;
end;
/


