set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1432',
      '02023004',
      NULL,
      1,
      NULL,
      213.362228,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      36.417843,
      1,
      NULL,
      2.881920,
      1.423461,
      0,
      1,
      0,
      2,
      0.874864,
      1.722537,
      1,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.605957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.618244,
      0.473567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.309253,
      5,
      5.632009,
      0.443812,
      1.370264,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0.641449,
      1,
      NULL,
      0.666086,
      2.238357,
      0.969130,
      1.488476,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      7.941176,
      NULL,
      3.619378,
      NULL,
      2,
      5.431853,
      6,
      6,
      NULL,
      2,
      7,
      1.231369,
      6,
      NULL,
      NULL,
      4.388142,
      1,
      NULL,
      NULL,
      3,
      0.300197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521471,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.373871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.155395,
      NULL,
      NULL,
      3.822688,
      0.151443,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458173,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.005265,
      0.409528,
      1.708698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353271,
      0.495162,
      NULL,
      0,
      2,
      3.233979,
      NULL,
      1.898658,
      NULL,
      3,
      NULL,
      1.327226,
      NULL,
      NULL,
      NULL,
      0.568856,
      1.324903,
      0,
      0.590452,
      0.608634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.908530,
      NULL,
      '1341',
      NULL,
      NULL,
      '3023',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      1,
      3,
      0.282738,
      3,
      0,
      1.285252,
      NULL,
      2);
commit;
end;
/


