set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '1341313',
      NULL,
      0,
      0.704241,
      0,
      '430030',
      0.693844,
      ' 1-11-1980',
      23.142109,
      NULL,
      0,
      NULL,
      NULL,
      0.010904,
      0.777971,
      0,
      1.245850,
      0,
      NULL,
      NULL,
      0,
      0.303168,
      1.878507,
      0.502474,
      NULL,
      NULL,
      NULL,
      1.458300,
      3,
      0,
      NULL,
      1.590356,
      1,
      0,
      2,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.614014,
      NULL,
      NULL,
      3.118406,
      0,
      3.865985,
      1.289007,
      2,
      3,
      NULL,
      2,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      1,
      1.060525,
      0.604201,
      1.460521,
      0,
      2,
      0.564490,
      1.430896,
      NULL,
      NULL,
      1.149906,
      NULL,
      NULL,
      1.893331,
      0,
      1.620319,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0.306871,
      NULL,
      4.634763,
      1,
      1,
      1,
      NULL,
      1.410400,
      NULL,
      0.494269,
      1,
      3.679765,
      0,
      2.147094,
      0.015663,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817262,
      0.870838,
      1,
      0.263299,
      4,
      2.583539,
      5.140058,
      4,
      2,
      6,
      5.551697,
      1.345257,
      0,
      0,
      6,
      1,
      2,
      1.721948,
      1,
      8.131292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.373898,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236028,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.342253,
      1,
      0.044151,
      NULL,
      NULL,
      NULL,
      1.285901,
      1,
      1,
      1.984868,
      0.969611,
      NULL,
      1.066182,
      NULL,
      NULL,
      NULL,
      0.059765,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.805325,
      3,
      0,
      2.919561,
      1.725212,
      NULL,
      0.648796,
      1,
      3.831779,
      0,
      NULL,
      0,
      1.847659,
      0,
      1.063661,
      0.844388,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.664162,
      '33203',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.829211,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


