set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '1131432',
      1,
      1,
      3,
      0,
      '040040',
      0.639948,
      ' 1- 5-1985',
      22,
      NULL,
      1.281350,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      2.747658,
      0.933444,
      0,
      NULL,
      1,
      0.693293,
      0,
      NULL,
      NULL,
      7.254128,
      NULL,
      3.180377,
      1.941305,
      1,
      0,
      2.736118,
      0,
      2,
      0.122350,
      0.659759,
      1.704650,
      NULL,
      NULL,
      1.020616,
      NULL,
      NULL,
      NULL,
      4.366523,
      2.509997,
      0,
      3,
      2,
      3.425193,
      0,
      3,
      3.942050,
      0,
      0,
      NULL,
      1,
      2,
      0,
      3.436024,
      NULL,
      0.646934,
      NULL,
      NULL,
      5,
      6.151452,
      0,
      NULL,
      0.314618,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728870,
      0,
      NULL,
      1.352419,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      0.283464,
      0.040327,
      0.833237,
      0.939874,
      1,
      0,
      0,
      1.830311,
      NULL,
      0.380672,
      1,
      NULL,
      1,
      2.969469,
      1.057571,
      2.136425,
      1,
      1.221405,
      0.540464,
      1.213344,
      1.185398,
      0.680248,
      NULL,
      NULL,
      4,
      1.277275,
      NULL,
      1.522107,
      7,
      6,
      0.321066,
      1.897268,
      NULL,
      5.232422,
      1,
      0.771264,
      0.615186,
      1,
      1,
      1.082986,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876437,
      0.743075,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.569117,
      0.666396,
      3.817956,
      3,
      1.874326,
      1,
      1.074064,
      NULL,
      0,
      5.547431,
      2.659599,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.199942,
      1.861691,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      1.331533,
      NULL,
      1,
      0.362625,
      NULL,
      3,
      1.490530,
      1,
      0.942044,
      0,
      1.589291,
      1.055978,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '41313',
      '',
      '',
      0.474360,
      '',
      '',
      '',
      1.586674,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


