set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '144',
      '43440010',
      59.961272,
      77,
      '0221343',
      181.468385,
      5,
      0,
      NULL,
      '203000',
      1,
      ' 4- 7-1996',
      46,
      15,
      0.251165,
      NULL,
      NULL,
      1.214437,
      1.187293,
      1.266480,
      0,
      1.006945,
      3,
      NULL,
      1.007477,
      1,
      7.341009,
      1.073234,
      NULL,
      0,
      0.648502,
      1,
      5,
      NULL,
      NULL,
      0.318397,
      1,
      NULL,
      3,
      0,
      3.773794,
      2.285476,
      2,
      0.808244,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.863680,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.881630,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1.382414,
      0,
      0,
      NULL,
      0,
      0.973191,
      0.477685,
      2.700888,
      0.157495,
      NULL,
      1,
      1,
      0.298840,
      NULL,
      NULL,
      NULL,
      3,
      5,
      9.317747,
      0.734402,
      5.444562,
      0,
      0.684753,
      3.220737,
      NULL,
      NULL,
      0.845300,
      1,
      4.055111,
      NULL,
      2,
      2.707198,
      2.573778,
      NULL,
      3.754257,
      5,
      3.907036,
      2,
      NULL,
      NULL,
      0.748525,
      0.861337,
      0,
      1,
      0,
      3,
      0.762078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.715157,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.592174,
      0.826509,
      3.358958,
      0.360235,
      1.230971,
      0.435351,
      1.995562,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.959616,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.191677,
      0.354573,
      1.582361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471969,
      1.945042,
      1,
      0.286531,
      NULL,
      0.512458,
      1.496458,
      1.155560,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1.387047,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.903632,
      '01402',
      '',
      '',
      1.809237,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      2,
      NULL,
      2.869055,
      NULL,
      0.824194,
      1,
      0,
      0,
      3);
commit;
end;
/


